# -*- coding: utf-8 -*-
from odoo import fields, models


class ResCompany(models.Model):
    _inherit = "res.company"

    disposal_journal = fields.Many2one(comodel_name='account.journal', string='Disposal Journal')
    capital_gain_account = fields.Many2one(comodel_name='account.account', string='Capital Gain disposal account')
    impairment_loss = fields.Many2one(comodel_name='account.account', string='Impairment Loss')
    gain_account_id = fields.Many2one(string='Depreciation Recovered', comodel_name='account.account',
                                      domain="[('deprecated', '=', False)]",
                                      help="Account used to write the journal item in case of gain while selling an asset")
    loss_account_id = fields.Many2one(string='Loss on Disposal', comodel_name='account.account', domain="[('deprecated', '=', False)]",
                                      help="Account used to write the journal item in case of loss while selling an asset")
